/*
 * Decompiled with CFR 0.152.
 */
package inputinfo;

import LinuxCommandExecutor.LinuxCommandExecutor;
import entityDB.InputDB;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Scanner;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class InputUpdate
extends Thread {
    private String udp;
    private int id;
    private String serverip;
    private String type;
    private boolean issecondary;
    private String client;

    public InputUpdate(String udp, int id, String serverip, boolean issecondary, String type, String client) {
        this.udp = udp;
        this.id = id;
        this.serverip = serverip;
        this.issecondary = issecondary;
        this.type = type;
        this.client = client;
    }

    @Override
    public void run() {
        try {
            if (this.type.equalsIgnoreCase("file")) {
                System.out.println("file");
                InputUpdate.inputUpdateFile(this.udp, this.id, this.serverip, this.issecondary, this.client);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private static void inputUpdateFile(String udp, int id, String server_ip, boolean issecondary, String client) {
        String json_string;
        block21: {
            json_string = "{";
            System.out.println("udp is---" + udp);
            if (issecondary) {
                try {
                    URL urL = new URL("http://" + server_ip + ":8000/getInputDetail");
                    System.out.println("url--" + urL);
                    HttpURLConnection httpURLConnection = (HttpURLConnection)urL.openConnection();
                    httpURLConnection.setDoOutput(true);
                    OutputStream os = httpURLConnection.getOutputStream();
                    OutputStreamWriter osw = new OutputStreamWriter(os, "UTF-8");
                    JSONObject obj = new JSONObject();
                    obj.put((Object)"udp", (Object)udp);
                    osw.write(obj.toJSONString());
                    osw.flush();
                    osw.close();
                    if (httpURLConnection.getResponseCode() != 200) break block21;
                    try (BufferedReader br = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));){
                        json_string = br.readLine();
                    }
                }
                catch (Exception e) {
                    System.out.println("Exception at reading input status from secondary server" + e);
                }
            } else {
                try {
                    ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                    if (client.equalsIgnoreCase("e2info")) {
                        processBuilder.command("bash", "-c", "timeout 7 Ridsys-RStreamer_Engine-1.6 -I ip -l 192.168.55.5 " + udp + " -P until --seconds 5 -P analyze --json -O drop");
                    } else {
                        processBuilder.command("bash", "-c", "timeout 7 Ridsys-RStreamer_Engine-1.6 -I ip " + udp + " -P until --seconds 5 -P analyze --json -O drop");
                    }
                    Process process = processBuilder.start();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    System.out.println("inputstream---" + process.getInputStream() + "   " + reader.read());
                    String line = "";
                    while ((line = reader.readLine()) != null) {
                        json_string = json_string + line;
                    }
                }
                catch (Exception e) {
                    System.out.println("Exception at run:" + e.getMessage());
                }
            }
        }
        InputUpdate.update(json_string, id);
    }

    public static String readInputFile(String udp) {
        String output = "";
        String path = "/home/user/InputInfo/InputCheck";
        try {
            File file = new File(path);
            String oldudp = "";
            Scanner scanner = new Scanner(file);
            String fileContents = "";
            while (scanner.hasNextLine()) {
                fileContents = fileContents + scanner.nextLine() + "\n";
            }
            String[] s = fileContents.split("\n");
            System.out.println(s.length);
            for (String ss : s) {
                System.out.println(ss);
                if (!ss.contains("export INPUT")) continue;
                oldudp = ss;
                oldudp = oldudp.substring(oldudp.lastIndexOf("=") + 1, oldudp.length());
                System.out.println(oldudp);
            }
            scanner.close();
            fileContents = fileContents.replace(oldudp, "\"" + udp + "\"");
            FileWriter writer = new FileWriter(file);
            writer.write(fileContents);
            writer.close();
            output = new LinuxCommandExecutor().inputScriptExe(path);
            System.out.println(output);
        }
        catch (Exception e) {
            System.out.println("Exception at primary: " + e);
        }
        return output;
    }

    public static void newFileUpdate(String json_string, int id) {
        try {
            boolean status = false;
            boolean isupdate = false;
            System.out.println(json_string);
            if (json_string != null && !json_string.equals("")) {
                JSONParser parser = new JSONParser();
                JSONArray jarr = (JSONArray)parser.parse(json_string);
                for (int i = 0; i < jarr.size(); ++i) {
                    JSONObject o = (JSONObject)jarr.get(i);
                    String hexString = o.get((Object)"Service ID").toString().trim();
                    if (hexString.startsWith("0x")) {
                        hexString = hexString.substring(2);
                    }
                    int program_num = Integer.parseInt(hexString, 16);
                    String service_name = o.get((Object)"Service Name").toString().trim();
                    String resolution = o.get((Object)"Resolution").toString().trim();
                    String videocodec = o.get((Object)"Video Codec").toString().trim();
                    String audiocodec = o.get((Object)"Audio Codec").toString().trim();
                    String bitrate = o.get((Object)"Bitrate").toString().trim();
                    if (new InputDB().getCountForInputAndAudio(id, "inputchannel") <= 0) {
                        isupdate = true;
                        new InputDB().insertInputChannels(service_name, videocodec, program_num, id, "");
                        new InputDB().updateResolution1(id, program_num, resolution);
                    } else if (new InputDB().checkData("program_no", String.valueOf(program_num), "input_channels", id) > 0) {
                        isupdate = true;
                        new InputDB().updateInputChannels(id, service_name, program_num, videocodec, "", "program_no", String.valueOf(program_num));
                        new InputDB().updateResolution1(id, program_num, resolution);
                    }
                    if (new InputDB().getCountForInputAndAudio(id, "audio") <= 0) {
                        new InputDB().insertAudioTrack("Default", audiocodec, id, program_num, bitrate);
                        continue;
                    }
                    if (new InputDB().checkData("channel_id", String.valueOf(program_num), "audio_track_details", id) <= 0 || new InputDB().hasResolution("channel_id", String.valueOf(program_num), "audio_track_details", id, "codec") > 0) continue;
                    new InputDB().updateAudioTrack(id, "Default", audiocodec, bitrate, program_num);
                }
                if (isupdate) {
                    new InputDB().updateStreamInputStatusAdd(id, jarr.size());
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception at: " + e);
        }
    }

    public static void update(String json_string, int id) {
        block22: {
            try {
                boolean status = false;
                if (json_string == null || json_string.equals("")) break block22;
                JSONParser parser = new JSONParser();
                Object obj = parser.parse(json_string);
                JSONObject json_data = (JSONObject)obj;
                JSONArray service = (JSONArray)json_data.get((Object)"services");
                JSONArray pids = (JSONArray)json_data.get((Object)"pids");
                if (service.size() <= 0) break block22;
                boolean isupdate = false;
                if (service.size() <= 1) {
                    System.out.println("SPTS");
                } else {
                    System.out.println("MPTS");
                }
                int size = 0;
                JSONArray pidarr = new JSONArray();
                for (int i = 0; i < service.size(); ++i) {
                    String service_name;
                    System.out.println("----------------------------" + i);
                    System.out.println(service.get(i));
                    JSONObject serobj = (JSONObject)service.get(i);
                    try {
                        pidarr = serobj.get((Object)"pids") != null ? (JSONArray)serobj.get((Object)"pids") : new JSONArray();
                    }
                    catch (Exception e) {
                        System.out.println(e);
                    }
                    int program_num = Integer.parseInt(serobj.get((Object)"id").toString());
                    try {
                        service_name = serobj.get((Object)"name").toString();
                    }
                    catch (Exception e) {
                        System.out.println("Unknown program:" + e.getMessage());
                        service_name = "Unknown";
                    }
                    String Providername = serobj.get((Object)"provider").toString();
                    String bitrate = serobj.get((Object)"bitrate").toString();
                    System.out.println("program_numm--" + serobj.get((Object)"id"));
                    System.out.println("service name--" + serobj.get((Object)"name"));
                    System.out.println("provider name--" + serobj.get((Object)"provider"));
                    System.out.println("bitrate name--" + serobj.get((Object)"bitrate"));
                    System.out.println("pid arra size----------------------------------" + pidarr.size());
                    if (pidarr.size() > 0) {
                        ++size;
                    }
                    for (int k = 0; k < pidarr.size(); ++k) {
                        System.out.println("pids--" + pidarr.get(k));
                        if (pids.size() <= 0) continue;
                        for (int j = 0; j < pids.size(); ++j) {
                            String language;
                            JSONObject o = (JSONObject)pids.get(j);
                            if (!o.get((Object)"id").equals(pidarr.get(k))) continue;
                            if (o.get((Object)"video").toString().equalsIgnoreCase("true")) {
                                System.out.println("video_type_---" + o.get((Object)"description"));
                                String vcodec = "";
                                try {
                                    vcodec = o.get((Object)"description").toString();
                                }
                                catch (Exception e) {
                                    vcodec = "Default";
                                }
                                String[] b = vcodec.split("\\(");
                                if (new InputDB().getCountForInputAndAudioAndProgramNo(id, "inputchannel", program_num) <= 0) {
                                    isupdate = true;
                                    new InputDB().insertInputChannels(service_name, vcodec, program_num, id, Providername);
                                    new InputDB().updateResolution(id, program_num, vcodec);
                                    continue;
                                }
                                if (new InputDB().checkData("program_no", String.valueOf(program_num), "input_channels", id) <= 0) continue;
                                isupdate = true;
                                new InputDB().updateInputChannels(id, service_name, program_num, vcodec, Providername, "program_no", String.valueOf(program_num));
                                new InputDB().updateResolution(id, program_num, vcodec);
                                continue;
                            }
                            if (!o.get((Object)"audio").toString().equalsIgnoreCase("true")) continue;
                            String a_codec = null;
                            try {
                                a_codec = o.get((Object)"description").toString();
                                language = o.get((Object)"language").toString();
                            }
                            catch (Exception e) {
                                language = "Default";
                                System.out.println("Exception at streams tag:" + e.getMessage());
                            }
                            String[] b = a_codec.split("\\(");
                            System.out.println("Language:" + language);
                            if (new InputDB().getCountForInputAndAudioAndProgramNo(id, "audio", program_num) <= 0) {
                                new InputDB().insertAudioTrack(language, a_codec, id, program_num, bitrate);
                            } else if (new InputDB().checkData("channel_id", String.valueOf(program_num), "audio_track_details", id) > 0 && new InputDB().hasResolution("channel_id", String.valueOf(program_num), "audio_track_details", id, "codec") <= 0) {
                                new InputDB().updateAudioTrack(id, language, a_codec, bitrate, program_num);
                            }
                            System.out.println("audio_type_---" + o.get((Object)"description"));
                            System.out.println("audio_type_---" + o.get((Object)"language"));
                        }
                    }
                }
                System.out.println("size-----------------------------------" + size + "  update: " + isupdate);
                if (isupdate) {
                    new InputDB().updateStreamInputStatusAdd(id, size);
                }
            }
            catch (Exception e) {
                System.out.println("Exception at: " + e);
            }
        }
    }

    public static boolean inputUpdateFFprobe(String udp, int id, String server_ip) throws ClassNotFoundException {
        boolean status;
        block23: {
            System.out.println("ffprobe");
            status = false;
            JSONArray Programs = new JSONArray();
            try {
                new InputDB().deleteTrackbyInputID(id);
                String json_string = "";
                if (!new InputDB().isSecondary(server_ip)) {
                    ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                    processBuilder.command("bash", "-c", "timeout 30s ffprobe -v quiet -print_format json -show_programs " + udp);
                    Process process = processBuilder.start();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String line = "";
                    while ((line = reader.readLine()) != null) {
                        json_string = json_string + line;
                        status = true;
                    }
                } else {
                    URL urL = new URL("http://" + server_ip + ":8000/StreamExtracter");
                    HttpURLConnection httpURLConnection = (HttpURLConnection)urL.openConnection();
                    httpURLConnection.setDoOutput(true);
                    OutputStream os = httpURLConnection.getOutputStream();
                    OutputStreamWriter osw = new OutputStreamWriter(os, "UTF-8");
                    JSONObject obj = new JSONObject();
                    obj.put((Object)"udp", (Object)udp);
                    osw.write(udp);
                    osw.flush();
                    osw.close();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                    String line = "";
                    json_string = line = bufferedReader.readLine();
                    System.out.println("line from server" + line);
                    if (line != null) {
                        status = true;
                    }
                }
                System.out.println(json_string);
                if (json_string == null || json_string.equals("")) break block23;
                JSONParser parser = new JSONParser();
                Object obj1 = parser.parse(json_string);
                JSONObject json_data = (JSONObject)obj1;
                try {
                    Programs = (JSONArray)json_data.get((Object)"programs");
                }
                catch (Exception e) {
                    System.out.println("No Programs");
                }
                for (int j = 0; j < Programs.size(); ++j) {
                    String service_name;
                    String provider = "";
                    JSONObject program = (JSONObject)Programs.get(j);
                    int program_num = Integer.parseInt(program.get((Object)"program_num").toString());
                    JSONObject service_obj = (JSONObject)program.get((Object)"tags");
                    try {
                        service_name = service_obj.get((Object)"service_name").toString();
                    }
                    catch (Exception e) {
                        service_name = "Unknown";
                    }
                    JSONArray Streams = (JSONArray)program.get((Object)"streams");
                    JSONObject tags = new JSONObject();
                    try {
                        tags = (JSONObject)program.get((Object)"tags");
                        provider = tags.get((Object)"service_provider").toString();
                    }
                    catch (Exception e) {
                        System.out.println(e);
                        provider = "No provider";
                    }
                    try {
                        for (int k = 0; k < Streams.size(); ++k) {
                            String language;
                            JSONObject stream = (JSONObject)Streams.get(k);
                            String codec_type = "";
                            try {
                                codec_type = stream.get((Object)"codec_type").toString();
                            }
                            catch (Exception e) {
                                codec_type = "No codec";
                            }
                            if (codec_type.contains("video") || codec_type.contains("no codec")) {
                                String v_codec = codec_type.contains("video") ? stream.get((Object)"codec_name").toString() : "no codec";
                                new InputDB().insertInputChannels(service_name, v_codec, program_num, id, provider);
                            }
                            if (!codec_type.contains("audio") && !codec_type.contains("no codec")) continue;
                            String a_codec = null;
                            String bitrate = null;
                            try {
                                if (codec_type.contains("audio")) {
                                    a_codec = stream.get((Object)"codec_name").toString();
                                    bitrate = stream.get((Object)"bit_rate").toString();
                                } else {
                                    a_codec = "no codec";
                                }
                                JSONObject stream_obj = (JSONObject)stream.get((Object)"tags");
                                language = stream_obj.get((Object)"language").toString();
                            }
                            catch (Exception e) {
                                language = "Default";
                                System.out.println("Exception at streams tag:" + e.getMessage());
                            }
                            new InputDB().insertAudioTrack(language, a_codec, id, program_num, bitrate);
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Exception at streams:" + e.getMessage());
                    }
                    new InputDB().updateStreamInputStatusAdd(id, Programs.size());
                }
            }
            catch (Exception e) {
                status = false;
                System.out.println("Exception at trackextractor :" + e.getMessage());
            }
        }
        return status;
    }
}

